/*------------------------------------------------------------------------------*
 * File Name: Passing1DArray.c 													*
 * Creation: 																	*
 * Purpose: Example on passing an 1D Array/vector to a NAG function				*
 * Copyright (c) OriginLab Corp. 2003, 2004, 2005, 2006, 2007, 2008, 2009, 2010	*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
////////////////////////////////////////////////////////////////////////////////////
#include <Origin.h>
#include <OC_nag.h>	// Header file for NAG library
// Note: The above header file does not include all the NAG library header files
// More header files can be added from the Origin C\System\NAG8 subfolder, such as:
// #include <NAG8\nagf07.h>


////////////////////////////////////////////////////////////////////////////////////
// This example computes summary statistics by calling a NAG library function
// It is assumed that a worksheet is active and the data is in column nDataCol and
// weights are in column nWtCol
//
void test_nag2(int nDataCol = 0, int nWtCol = 1)
{
	// Point to the data
	Worksheet wks = Project.ActiveLayer();
	if( !wks ) return;
            
	// Construct data range
	DataRange	dr;
	dr.Add(wks, nDataCol, "X"); // data
	dr.Add(wks, nWtCol, "W"); // weight
	DWORD dwDataRules = DRR_BAD_WEIGHT_TREATMENT;
	int index = 0; //we have only one range, so index is 0
	vector vecData, vecWeights;
	int nn = dr.GetData(dwDataRules, index, NULL, NULL, &vecData, NULL, NULL, NULL, &vecWeights);
	if(nn < 0)
		return; // error, should return 0 which was the column index for data

	// Check for missing values in the data        
	vector<int> vnRowsMissing;
	vector vMissingValues;
	nn = dr.GetMissingData(dwDataRules, index, &vnRowsMissing, &vMissingValues);
	if(vnRowsMissing.GetSize() > 0)
	{
		out_str("Missing values are skipped");
		for(int ii = 0; ii < vnRowsMissing.GetSize(); ii++)
			printf("%d:Row %d\n",ii+1, vnRowsMissing[ii]);
	}

	// Call NAG function
	double dMean, dSD, dSkew, dKurt, dMin, dMax, dSum;
	int nDataLen, nOK;
	nDataLen = vecData.GetSize();
	NagError nagerror;
	nag_summary_stats_1var(nDataLen, vecData, vecWeights, &nOK, &dMean, &dSD, &dSkew, &dKurt, &dMin, &dMax, &dSum, &nagerror);
	// See the NAG PDF for documentation on this function
            
	// Report results of call            
	// NagError is a struct that contains information on nag function call status
	// See nag_types.h file for details on this struct
	if( nagerror.code != 0 )
	{
		printf("Operation Failed: NAG function error code = %d\r\n",nagerror.code);
		printf("message from NAG:\n%s\n", nagerror.message);
		return;
	}
	printf("Dataset length = %d\r\n", nOK);
	printf("          mean = %f\r\n", dMean);
	printf("     std. dev. = %f\r\n", dSD);
	printf("      skewness = %f\r\n", dSkew);
	printf("      kurtosis = %f\r\n", dKurt);
	printf("           min = %f\r\n", dMin);
	printf("           max = %f\r\n", dMax);
	printf("sum of weights = %f\r\n\r\n", dSum);
}
